package model;

import model.comparisons.Comparison1;
import model.comparisons.Comparison2;
import model.comparisons.Comparison3;
import model.comparisons.Comparison4;
import model.comparisons.Comparison5;
import model.comparisons.Comparison6;

public class Execution implements IExecution {

	private static final int NUMBCOMP = 6;
	private int N;
	private boolean[] isactives = new boolean[NUMBCOMP];
	private IComparison[] comparisons = new IComparison[NUMBCOMP];
	private String[] times = new String[NUMBCOMP];

	public Execution() {
		comparisons[0] = new Comparison1();
		comparisons[1] = new Comparison2();
		comparisons[2] = new Comparison3();
		comparisons[3] = new Comparison4();
		comparisons[4] = new Comparison5();
		comparisons[5] = new Comparison6();

	}

	public void setParameter(int N) {
		for (int i = 0; i < NUMBCOMP; i++) {
			comparisons[i].setN(N);
		}
		this.N = N;

	}

	public void setActives(int index, boolean isactive) {
		this.isactives[index] = isactive;
		comparisons[index].setActive(isactive);
	}

	public boolean[] getActives() {
		return isactives;
	}

	public void run() {

		for (int i = 0; i < 6; i++) {
			if (isactives[i]) {
				// da buttare nel TimesPanel ed è fatta
				// System.out.println(comparisons[i].getTime());

				float[] tmp = comparisons[i].getTime();
				// times[i] = new String();
				times[i] = String.format("%.3fms %.3fms", tmp[0], tmp[1]);

			}
		}

	}

	public String[] getTimes() {
		return times;
	}

}
